/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.toolkit.design.property.workflow;

import filenet.vw.api.VWFieldDefinition;
import filenet.vw.base.VWDebug;
import filenet.vw.toolkit.design.canvas.process.VWDesignerBasePropertyPanel;
import filenet.vw.toolkit.design.property.VWAuthPropertyData;
import filenet.vw.toolkit.design.property.resources.VWResource;
import filenet.vw.toolkit.design.property.workflow.VWAdvancedTabPanel;
import filenet.vw.toolkit.design.property.workflow.VWAttachmentPanel;
import filenet.vw.toolkit.design.property.workflow.VWFieldPanel;
import filenet.vw.toolkit.design.property.workflow.VWGeneralPanel;
import filenet.vw.toolkit.design.property.workflow.VWGuidFieldsPanel;
import filenet.vw.toolkit.design.property.workflow.VWMapPanel;
import filenet.vw.toolkit.design.property.workflow.VWMilestonesTabPanel;
import filenet.vw.toolkit.design.property.workflow.VWPartnerLinksPanel;
import filenet.vw.toolkit.design.property.workflow.VWWSGeneralTabPanel;
import filenet.vw.toolkit.design.property.workflow.VWWorkflowGroupPanel;
import filenet.vw.toolkit.design.property.workflow.VWXMLDataFieldPanel;
import filenet.vw.toolkit.design.property.workflow.VWXMLSchemaPanel;
import filenet.vw.toolkit.utils.VWHelp;
import filenet.vw.toolkit.utils.uicontrols.tabbedPane.VWCustomTabbedPane;
import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.Icon;
import javax.swing.JPanel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class VWWorkflowPropPanel
extends VWDesignerBasePropertyPanel
implements ChangeListener {
    private static final int TAB_GENERAL = 0;
    private static final int TAB_DATA_FIELDS = 1;
    private static final int TAB_ATTACHMENTS = 2;
    private static final int TAB_GUID_FIELDS = 3;
    private static final int TAB_WFL_GROUPS = 4;
    private static final int TAB_SUBMAPS = 5;
    private static final int TAB_MILESTONES = 6;
    private static final int TAB_WEB_SERVICES = 7;
    private static final int TAB_ADVANCED = 8;
    private static final int WS_TAB_OFFSET = 21;
    private static final int TAB_WS_GENERAL = 21;
    private static final int TAB_WS_PARTNER_LINKS = 22;
    private static final int TAB_WS_XML_SCHEMA = 23;
    private static final int TAB_WS_XML_DATA_FIELDS = 24;
    private VWCustomTabbedPane m_tabbedPane;
    private VWGeneralPanel m_generalPanel;
    private VWFieldPanel m_fieldPanel;
    private VWAttachmentPanel m_attachmentPanel;
    private VWGuidFieldsPanel m_guidFieldsPanel;
    private VWWorkflowGroupPanel m_workflowGroupPanel;
    private VWMapPanel m_submapPanel;
    private VWMilestonesTabPanel m_milestonesPanel;
    private VWAdvancedTabPanel m_advancedPanel;
    private VWCustomTabbedPane m_wsTabbedPane;
    private VWWSGeneralTabPanel m_wsGeneralPanel;
    private VWPartnerLinksPanel m_partnerLinksPanel;
    private VWXMLSchemaPanel m_xmlSchemaPanel;
    private VWXMLDataFieldPanel m_xmlDataFieldPanel;

    public VWWorkflowPropPanel(VWAuthPropertyData authPropertyData) {
        super(authPropertyData);
    }

    public void stopEditing() {
        if (this.m_fieldPanel != null) {
            this.m_fieldPanel.stopEditing();
        }
        if (this.m_attachmentPanel != null) {
            this.m_attachmentPanel.stopEditing();
        }
        if (this.m_guidFieldsPanel != null) {
            this.m_guidFieldsPanel.stopEditing();
        }
        if (this.m_workflowGroupPanel != null) {
            this.m_workflowGroupPanel.stopEditing();
        }
        if (this.m_submapPanel != null) {
            this.m_submapPanel.stopEditing();
        }
        if (this.m_milestonesPanel != null) {
            this.m_milestonesPanel.stopEditing();
        }
        if (this.m_partnerLinksPanel != null) {
            this.m_partnerLinksPanel.stopEditing();
        }
        if (this.m_xmlSchemaPanel != null) {
            this.m_xmlSchemaPanel.stopEditing();
        }
        if (this.m_xmlDataFieldPanel != null) {
            this.m_xmlDataFieldPanel.stopEditing();
        }
        if (this.m_advancedPanel != null) {
            this.m_advancedPanel.stopEditing();
        }
    }

    public int getCurrentTabIndex() {
        int nIndex = -1;
        if (this.m_tabbedPane != null && (nIndex = this.m_tabbedPane.getSelectedIndex()) == 7 && this.m_wsTabbedPane != null) {
            switch (this.m_wsTabbedPane.getSelectedIndex()) {
                case 0: {
                    nIndex = 21;
                    break;
                }
                case 1: {
                    nIndex = 22;
                    break;
                }
                case 2: {
                    nIndex = 23;
                    break;
                }
                case 3: {
                    nIndex = 24;
                }
            }
        }
        return nIndex;
    }

    public void showTab(int nTabIndex, String fieldName) {
        switch (nTabIndex) {
            case 0: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                if (this.m_tabbedPane == null) break;
                this.m_tabbedPane.setSelectedIndex(nTabIndex);
                break;
            }
            case 1: {
                if (this.m_tabbedPane == null || this.m_fieldPanel == null) break;
                this.m_tabbedPane.setSelectedIndex(nTabIndex);
                this.m_fieldPanel.highlightField(fieldName);
                break;
            }
            case 2: {
                if (this.m_tabbedPane == null || this.m_attachmentPanel == null) break;
                this.m_tabbedPane.setSelectedIndex(nTabIndex);
                this.m_attachmentPanel.highlightField(fieldName);
                break;
            }
            case 3: {
                if (this.m_tabbedPane == null || this.m_guidFieldsPanel == null) break;
                this.m_tabbedPane.setSelectedIndex(nTabIndex);
                this.m_guidFieldsPanel.highlightField(fieldName);
                break;
            }
            case 21: 
            case 22: 
            case 23: 
            case 24: {
                if (this.m_tabbedPane == null || this.m_wsTabbedPane == null) break;
                this.m_tabbedPane.setSelectedIndex(7);
                this.m_wsTabbedPane.setSelectedIndex(nTabIndex - 21);
            }
        }
    }

    public int lookupTabFromErrorType(int nErrorType, String itemName) {
        switch (nErrorType) {
            case 4: {
                switch (this.findFieldType(itemName)) {
                    case 32: {
                        return 2;
                    }
                    case 64: {
                        return 4;
                    }
                    case 128: {
                        return 24;
                    }
                    case 512: {
                        return 3;
                    }
                }
                return 1;
            }
            case 8: {
                return 6;
            }
            case 10: {
                return 22;
            }
            case 9: {
                return 8;
            }
            case 11: {
                return 23;
            }
        }
        return 0;
    }

    public void reinitialize() {
        try {
            int nCurrentTabIndex = this.getCurrentTabIndex();
            this.removeAll();
            this.createControls();
            if (nCurrentTabIndex != -1) {
                this.showTab(nCurrentTabIndex, null);
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    public Object getDataObject() {
        if (this.m_authPropertyData != null) {
            return this.m_authPropertyData.getWorkflowDefinition();
        }
        return null;
    }

    public void setDataObject(Object dataObject) {
    }

    public String getDisplayName() {
        return VWResource.s_workflowPropertiesDlgTitle;
    }

    public String getToolTip() {
        return null;
    }

    public Icon getIcon() {
        return null;
    }

    public void displayHelpPage() {
        StringBuffer helpString = new StringBuffer(VWHelp.Help_Process_Designer);
        switch (this.getCurrentTabIndex()) {
            case 0: {
                helpString.append("bpfdh173.htm");
                break;
            }
            case 1: {
                helpString.append("bpfdh172.htm");
                break;
            }
            case 2: {
                helpString.append("bpfdh171.htm");
                break;
            }
            case 3: {
                helpString.append("bpfdh202.htm");
                break;
            }
            case 4: {
                helpString.append("bpfdh181.htm");
                break;
            }
            case 5: {
                helpString.append("bpfdh175.htm");
                break;
            }
            case 6: {
                helpString.append("bpfdh174.htm");
                break;
            }
            case 7: {
                helpString.append("bpfdh176.htm");
                break;
            }
            case 21: {
                helpString.append("bpfdh177.htm");
                break;
            }
            case 22: {
                helpString.append("bpfdh178.htm");
                break;
            }
            case 23: {
                helpString.append("bpfdh180.htm");
                break;
            }
            case 24: {
                helpString.append("bpfdh179.htm");
                break;
            }
            case 8: {
                helpString.append("bpfdh170.htm");
                break;
            }
            default: {
                return;
            }
        }
        VWHelp.displayPage(helpString.toString());
    }

    public void releaseReferences() {
        if (this.m_tabbedPane != null) {
            this.m_tabbedPane.removeChangeListener(this);
            this.m_tabbedPane.releaseReferences();
            this.m_tabbedPane = null;
        }
        if (this.m_generalPanel != null) {
            this.m_generalPanel.releaseReferences();
            this.m_generalPanel = null;
        }
        if (this.m_fieldPanel != null) {
            this.m_fieldPanel.releaseReferences();
            this.m_fieldPanel = null;
        }
        if (this.m_attachmentPanel != null) {
            this.m_attachmentPanel.releaseReferences();
            this.m_attachmentPanel = null;
        }
        if (this.m_guidFieldsPanel != null) {
            this.m_guidFieldsPanel.releaseReferences();
            this.m_guidFieldsPanel = null;
        }
        if (this.m_workflowGroupPanel != null) {
            this.m_workflowGroupPanel.releaseReferences();
            this.m_workflowGroupPanel = null;
        }
        if (this.m_submapPanel != null) {
            this.m_submapPanel.releaseReferences();
            this.m_submapPanel = null;
        }
        if (this.m_milestonesPanel != null) {
            this.m_milestonesPanel.releaseReferences();
            this.m_milestonesPanel = null;
        }
        if (this.m_wsTabbedPane != null) {
            this.m_wsTabbedPane.removeChangeListener(this);
            this.m_wsTabbedPane.releaseReferences();
            this.m_wsTabbedPane = null;
        }
        if (this.m_wsGeneralPanel != null) {
            this.m_wsGeneralPanel.releaseReferences();
            this.m_wsGeneralPanel = null;
        }
        if (this.m_partnerLinksPanel != null) {
            this.m_partnerLinksPanel.releaseReferences();
            this.m_partnerLinksPanel = null;
        }
        if (this.m_xmlSchemaPanel != null) {
            this.m_xmlSchemaPanel.releaseReferences();
            this.m_xmlSchemaPanel = null;
        }
        if (this.m_xmlDataFieldPanel != null) {
            this.m_xmlDataFieldPanel.releaseReferences();
            this.m_xmlDataFieldPanel = null;
        }
        if (this.m_advancedPanel != null) {
            this.m_advancedPanel.releaseReferences();
            this.m_advancedPanel = null;
        }
    }

    public void stateChanged(ChangeEvent event) {
        if (event.getSource().equals(this.m_tabbedPane)) {
            this.stopEditing();
        }
    }

    protected void createControls() {
        try {
            this.m_tabbedPane = new VWCustomTabbedPane(0);
            this.m_generalPanel = new VWGeneralPanel();
            this.m_generalPanel.init(this.m_authPropertyData);
            this.m_tabbedPane.addTab(VWResource.s_generalTabStr, this.m_generalPanel);
            this.m_fieldPanel = new VWFieldPanel();
            this.m_fieldPanel.init(this.m_authPropertyData);
            this.m_tabbedPane.addTab(VWResource.s_fieldsStr, this.m_fieldPanel);
            this.m_attachmentPanel = new VWAttachmentPanel();
            this.m_attachmentPanel.init(this.m_authPropertyData);
            this.m_tabbedPane.addTab(VWResource.s_attachmentsStr, this.m_attachmentPanel);
            this.m_workflowGroupPanel = new VWWorkflowGroupPanel();
            this.m_workflowGroupPanel.init(this.m_authPropertyData);
            this.m_tabbedPane.addTab(VWResource.s_workflowGroupsStr, this.m_workflowGroupPanel);
            this.m_submapPanel = new VWMapPanel();
            this.m_submapPanel.init(this.m_authPropertyData);
            this.m_tabbedPane.addTab(VWResource.s_maps, this.m_submapPanel);
            this.m_milestonesPanel = new VWMilestonesTabPanel();
            this.m_milestonesPanel.init(this.m_authPropertyData);
            this.m_tabbedPane.addTab(VWResource.s_milestonesStr, this.m_milestonesPanel);
            if (this.m_authPropertyData.getSessionInfo().getDisplayP8BPMFunctionality()) {
                JPanel wsPanel = new JPanel(new BorderLayout(6, 6));
                this.m_wsTabbedPane = new VWCustomTabbedPane(1);
                this.m_wsGeneralPanel = new VWWSGeneralTabPanel();
                this.m_wsGeneralPanel.init(this.m_authPropertyData);
                this.m_wsTabbedPane.addTab(VWResource.s_generalTabStr, this.m_wsGeneralPanel);
                this.m_partnerLinksPanel = new VWPartnerLinksPanel();
                this.m_partnerLinksPanel.init(this.m_authPropertyData);
                this.m_wsTabbedPane.addTab(VWResource.s_partnerLinks, this.m_partnerLinksPanel);
                this.m_xmlSchemaPanel = new VWXMLSchemaPanel();
                this.m_xmlSchemaPanel.init(this.m_authPropertyData);
                this.m_wsTabbedPane.addTab(VWResource.s_xmlSchema, this.m_xmlSchemaPanel);
                this.m_xmlDataFieldPanel = new VWXMLDataFieldPanel();
                this.m_xmlDataFieldPanel.init(this.m_authPropertyData);
                this.m_wsTabbedPane.addTab(VWResource.s_xmlDataFields, this.m_xmlDataFieldPanel);
                this.m_wsTabbedPane.setSelectedIndex(0);
                wsPanel.add((Component)this.m_wsTabbedPane, "Center");
                this.m_tabbedPane.addTab(VWResource.s_webServicesStr, wsPanel);
            }
            this.m_advancedPanel = new VWAdvancedTabPanel();
            this.m_advancedPanel.init(this.m_authPropertyData);
            this.m_tabbedPane.addTab(VWResource.s_advancedTabStr, this.m_advancedPanel);
            this.setLayout(new BorderLayout());
            this.add((Component)this.m_tabbedPane, "Center");
            this.m_tabbedPane.setSelectedIndex(0);
            this.m_tabbedPane.addChangeListener(this);
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    private int findFieldType(String fieldName) {
        if (this.m_authPropertyData != null) {
            try {
                VWFieldDefinition fieldDef = this.m_authPropertyData.getField(fieldName);
                if (fieldDef != null) {
                    return fieldDef.getFieldType();
                }
            }
            catch (Exception ex) {
                VWDebug.logException(ex);
            }
        }
        return 1;
    }
}

